/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.userprof;

import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.base.userprof.AddUserBean;
import com.ibm.hwmca.base.userprof.NewUserBean;
import com.ibm.hwmca.base.userprof.RoleTree;
import com.ibm.hwmca.base.userprof.UserAttributes;
import com.ibm.hwmca.base.userprof.UserProfErrorIds;
import com.ibm.hwmca.base.userprof.UserProfSaveRestore;
import com.ibm.hwmca.base.userprof.UserProfilesException;
import com.ibm.hwmca.base.userprof.UserProfilesPlugin;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.HwmcaParser;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserProfTasklet
extends PanelTasklet
implements UserProfErrorIds {
    AddUserBean adduserBean;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "com.ibm.hwmca.base.userprof.UserProf");
    private static final String TRACE_MASKF = "USRPROSF";
    private static final String TRACE_MASKT = "USRPROST";
    private static final String TRACE_MASKD = "USRPROSD";
    private static DataRepApp dataRepApp = DataRepApp.getDataRepApp();
    private static String sourceDataKey = new UserProfSaveRestore().getCustomDataKey();
    private static boolean panelUp = false;
    private static final String ADDUSERBEAN_NAME = "AddUserBean";
    private static final String NEWUSERBEAN_NAME = "NewUserBean";
    private static final String CUSTOMIZE_XML = "customize.xml";
    List moRoles = new ArrayList();
    List taskRoles = new ArrayList();
    List curUsers = new ArrayList();
    static int mySel = 0;
    private LocalizableText lStrBusy;
    private LocalizableText lStrUpdate;
    private LocalizableText lStrTitle;
    private LocalizableText lText;
    boolean usersBuilt = false;
    boolean rolesBuilt = false;
    UserProfilesPlugin implClass;
    int expDays = 0;

    public UserProfTasklet() {
        Trace.trace(TRACE_MASKT, "<> UserProfTasklet constructor ");
    }

    public void init(PresentationTaskParms parms) {
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "<> UserProfTasklet.logException()");
        new FrameworkLog(UserProfErrorIds.LOGINFO, 1280, throwable).log();
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block58: {
            if (request.isInitialRequest()) {
                this.implClass = UserProfTasklet.loadPlugin();
                if (this.implClass == null) {
                    BaseMessageTitle title = new BaseMessageTitle("ADM9016");
                    MessageText[] bmt = new BaseMessageText[]{new BaseMessageText("ADM0019")};
                    LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                    try {
                        LocalizableText answer = this.showMessageBox(false, title, bmt, "ADM0019", MsgType.INFORMATION_MESSAGE, options);
                    }
                    catch (Exception exc) {
                        HException ex = new HException(exc);
                        new FrameworkLog(classLogInfo, 1025, ex).log();
                    }
                    response.noAction();
                } else {
                    try {
                        this.lStrUpdate = new LocalizableText(BaseTextBundle.getBundleName(), "usrprof.init.update.text");
                        this.lStrBusy = new LocalizableText(BaseTextBundle.getBundleName(), "usrprof.init.busy.text");
                        this.lStrTitle = new LocalizableText(BaseTextBundle.getBundleName(), "usrprof.init.busy.title");
                        this.showBusyDialog(this.lStrTitle, this.lStrBusy);
                        this.curUsers = this.buildTopUsers();
                        if (this.curUsers.size() == 0) {
                            BaseMessageTitle title = new BaseMessageTitle("ADM9002");
                            MessageText[] bmt = new BaseMessageText[]{new BaseMessageText("ADM0003")};
                            LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                            try {
                                LocalizableText answer = this.showMessageBox(false, title, bmt, "ADM0003", MsgType.INFORMATION_MESSAGE, options);
                            }
                            catch (Exception exc) {
                                HException ex = new HException(exc);
                                new FrameworkLog(classLogInfo, 1025, ex).log();
                            }
                            response.noAction();
                            break block58;
                        }
                        this.adduserBean = new AddUserBean(this.curUsers);
                        this.adduserBean.setBeanName(ADDUSERBEAN_NAME);
                        response.replace("com.ibm.hwmca.base.userprof.res.UserProfRes", "AddUserPanel", this.adduserBean);
                        this.destroyBusyDialog();
                    }
                    catch (UserProfilesException e) {
                        this.destroyBusyDialog();
                        BaseMessageTitle title = new BaseMessageTitle("ADM9017");
                        MessageText[] bmt = new BaseMessageText[1];
                        Object[] values = new String[]{e.getLocalizedMessage()};
                        bmt[0] = new BaseMessageText("ADM0023", values);
                        LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                        try {
                            LocalizableText answer = this.showMessageBox(false, title, bmt, "ADM0023", MsgType.ERROR_MESSAGE, options);
                        }
                        catch (Exception exc) {
                            HException ex = new HException(exc);
                            new FrameworkLog(classLogInfo, 1025, ex).log();
                        }
                        response.noAction();
                    }
                }
            } else if (request.isDisposed() || request.isCanceled()) {
                if (panelUp) {
                    response.dispose();
                    panelUp = false;
                } else {
                    response.terminate();
                }
            } else {
                try {
                    String myAction = (String)request.getData("action");
                    if (myAction.equalsIgnoreCase("CANCEL")) {
                        response.terminate();
                        break block58;
                    }
                    if (myAction.equalsIgnoreCase("add")) {
                        NewUserBean newUserBean = null;
                        panelUp = true;
                        this.showBusyDialog(this.lStrTitle, this.lStrBusy);
                        if (!this.rolesBuilt) {
                            this.buildRoles();
                            this.rolesBuilt = true;
                        }
                        if (!this.usersBuilt) {
                            this.curUsers = this.buildTopUsers();
                            this.usersBuilt = true;
                        }
                        newUserBean = new NewUserBean(this.taskRoles, this.moRoles, this.curUsers, this.implClass.getDefaultCaseSensitivity(), this.implClass.allowMultipleTaskRoles(), this.implClass.allowMultipleManagedResourceRoles(), this.implClass.getDefaultRemoteAccess());
                        newUserBean.setBeanName(NEWUSERBEAN_NAME);
                        response.openModalChild("com.ibm.hwmca.base.userprof.res.UserProfRes", "NewUserPanel", newUserBean);
                        this.destroyBusyDialog();
                        break block58;
                    }
                    if (myAction.equalsIgnoreCase("modify")) {
                        UserAttributes aUser;
                        UserAttributes modUser;
                        this.showBusyDialog(this.lStrTitle, this.lStrBusy);
                        Integer selection = (Integer)request.getData("index");
                        mySel = selection;
                        panelUp = true;
                        if (!this.rolesBuilt) {
                            this.buildRoles();
                            this.rolesBuilt = true;
                        }
                        if (!this.usersBuilt) {
                            this.curUsers = this.buildTopUsers();
                            this.usersBuilt = true;
                        }
                        if ((modUser = this.implClass.getUser((aUser = (UserAttributes)this.curUsers.get(mySel)).getUserid())).isEditable()) {
                            NewUserBean newUserBean = new NewUserBean(this.taskRoles, this.moRoles, modUser, this.implClass.getDefaultCaseSensitivity(), this.implClass.allowMultipleTaskRoles(), this.implClass.allowMultipleManagedResourceRoles(), false, this.implClass.getDefaultRemoteAccess());
                            newUserBean.setBeanName(NEWUSERBEAN_NAME);
                            response.openModalChild("com.ibm.hwmca.base.userprof.res.UserProfRes", "NewUserPanel", newUserBean);
                            this.destroyBusyDialog();
                        } else {
                            NewUserBean newUserBean = new NewUserBean(this.taskRoles, this.moRoles, modUser, this.implClass.getDefaultCaseSensitivity(), this.implClass.allowMultipleTaskRoles(), this.implClass.allowMultipleManagedResourceRoles(), true, this.implClass.getDefaultRemoteAccess());
                            newUserBean.setBeanName(NEWUSERBEAN_NAME);
                            response.openModalChild("com.ibm.hwmca.base.userprof.res.UserProfRes", "NewUserPanel", newUserBean);
                            this.destroyBusyDialog();
                        }
                        break block58;
                    }
                    if (myAction.equalsIgnoreCase("copy")) {
                        this.showBusyDialog(this.lStrTitle, this.lStrBusy);
                        Integer selection = (Integer)request.getData("index");
                        mySel = selection;
                        panelUp = true;
                        if (!this.rolesBuilt) {
                            this.buildRoles();
                            this.rolesBuilt = true;
                        }
                        if (!this.usersBuilt) {
                            this.curUsers = this.buildTopUsers();
                            this.usersBuilt = true;
                        }
                        UserAttributes aUser = (UserAttributes)this.curUsers.get(mySel);
                        UserAttributes copiedUser = this.implClass.getUser(aUser.getUserid());
                        NewUserBean newUserBean = new NewUserBean(this.taskRoles, this.moRoles, this.curUsers, copiedUser, this.implClass.getDefaultCaseSensitivity(), this.implClass.allowMultipleTaskRoles(), this.implClass.allowMultipleManagedResourceRoles(), this.implClass.getDefaultRemoteAccess());
                        newUserBean.setBeanName(NEWUSERBEAN_NAME);
                        response.openModalChild("com.ibm.hwmca.base.userprof.res.UserProfRes", "NewUserPanel", newUserBean);
                        this.destroyBusyDialog();
                        break block58;
                    }
                    if (myAction.equalsIgnoreCase("remove")) {
                        Integer selection = (Integer)request.getData("index");
                        mySel = selection;
                        Trace.trace(TRACE_MASKT, "remove task selection " + mySel);
                        this.showBusyDialog(this.lStrTitle, this.lStrBusy);
                        this.deleteObject(mySel);
                        this.usersBuilt = false;
                        this.destroyBusyDialog();
                        PanelTaskletRequest requesta = new PanelTaskletRequest();
                        requesta.setData("action", "refresh_users");
                        this.postRequest(ADDUSERBEAN_NAME, requesta);
                        response.noAction();
                        break block58;
                    }
                    if (myAction.equalsIgnoreCase("addUser")) {
                        Trace.trace(TRACE_MASKT, "--> inside addUser");
                        String newName = (String)request.getData("name");
                        Trace.trace(TRACE_MASKT, "before implclass validateUserid");
                        this.implClass.validateUserid(newName);
                        Trace.trace(TRACE_MASKT, "after implclass validateUserid");
                        String password = (String)request.getData("password");
                        byte[] pass = password.getBytes();
                        String description = (String)request.getData("description");
                        LocalizableText desc = new LocalizableText(description);
                        String expireDays = (String)request.getData("expireDays");
                        this.expDays = expireDays != null ? Integer.valueOf(expireDays) : 0;
                        List objectData = (List)request.getData("objectData");
                        List taskData = (List)request.getData("taskData");
                        Integer remoteInt = (Integer)request.getData("remoteAccess");
                        int access = remoteInt;
                        Trace.trace(TRACE_MASKT, "before implclass validatePassword");
                        if (this.expDays > 0) {
                            this.implClass.validatePassword(password, true);
                        } else {
                            this.implClass.validatePassword(password, false);
                        }
                        Trace.trace(TRACE_MASKT, "after implclass validatePassword");
                        UserAttributes userAttr = new UserAttributes(newName, pass, desc);
                        Trace.trace(TRACE_MASKT, "UserProfTasklet:addUser name " + newName);
                        Trace.trace(TRACE_MASKT, "UserProfTasklet:addUser desc " + desc);
                        Trace.trace(TRACE_MASKT, "UserProfTasklet:addUser expDays " + expireDays);
                        List ids = this.buildObjectidList(objectData);
                        userAttr.setRoles(0, ids);
                        Trace.trace(TRACE_MASKT, "UserProfTasklet:objectData size " + ids.size());
                        ids = this.buildObjectidList(taskData);
                        userAttr.setRoles(1, ids);
                        Trace.trace(TRACE_MASKT, "UserProfTasklet:taskData size " + ids.size());
                        if (this.expDays > 0) {
                            userAttr.setPasswordExpiration(this.expDays);
                            userAttr.setPasswordRulesEnforced(true);
                        } else {
                            userAttr.setPasswordRulesEnforced(false);
                        }
                        Trace.trace(TRACE_MASKT, "addUser access code " + access);
                        if (access == 0) {
                            userAttr.setRemoteAccess(false);
                        } else {
                            userAttr.setRemoteAccess(true);
                        }
                        Trace.trace(TRACE_MASKT, "UserProfTasklet:calling addUser impl");
                        Trace.trace(TRACE_MASKT, "remoteAccess value is " + userAttr.isRemoteAccessPermitted());
                        this.implClass.addUser(userAttr);
                        Trace.trace(TRACE_MASKT, "after implclass addUser");
                        dataRepApp.displayCustDataWarning(sourceDataKey, this);
                        this.usersBuilt = false;
                        Trace.trace(TRACE_MASKT, "<- inside addUser");
                        PanelTaskletRequest requesta = new PanelTaskletRequest();
                        requesta.setData("action", "refresh_users");
                        this.postRequest(ADDUSERBEAN_NAME, requesta);
                        response.dispose(NEWUSERBEAN_NAME);
                        break block58;
                    }
                    if (myAction.equalsIgnoreCase("modifyUser")) {
                        UserAttributes userAttr;
                        Trace.trace(TRACE_MASKT, "--> inside modifyUser");
                        String newName = (String)request.getData("name");
                        Integer sel = (Integer)request.getData("pwchange");
                        int pwchg = sel;
                        String description = (String)request.getData("description");
                        LocalizableText desc = new LocalizableText(description);
                        List objectData = (List)request.getData("objectData");
                        List taskData = (List)request.getData("taskData");
                        String expireDays = (String)request.getData("expireDays");
                        this.expDays = Integer.valueOf(expireDays);
                        Trace.trace(TRACE_MASKT, "expDays is " + expireDays);
                        Trace.trace(TRACE_MASKT, "pwchg is " + pwchg);
                        if (pwchg == 1) {
                            String password = new String((String)request.getData("password"));
                            byte[] pass = password.getBytes();
                            Trace.trace(TRACE_MASKT, "before implclass validatePassword");
                            if (this.expDays > 0) {
                                this.implClass.validatePassword(password, true);
                            } else {
                                this.implClass.validatePassword(password, false);
                            }
                            Trace.trace(TRACE_MASKT, "after implclass validatePassword");
                            userAttr = new UserAttributes(newName, pass, desc);
                        } else {
                            String password = "";
                            userAttr = new UserAttributes(newName, null, desc);
                        }
                        List ids = this.buildObjectidList(objectData);
                        userAttr.setRoles(0, ids);
                        ids = this.buildObjectidList(taskData);
                        userAttr.setRoles(1, ids);
                        Integer remoteInt = (Integer)request.getData("remoteAccess");
                        int access = remoteInt;
                        Trace.trace(TRACE_MASKT, "addUser access code " + access);
                        if (access == 0) {
                            userAttr.setRemoteAccess(false);
                        } else {
                            userAttr.setRemoteAccess(true);
                        }
                        Trace.trace(TRACE_MASKT, "remoteAccess value is " + userAttr.isRemoteAccessPermitted());
                        if (this.expDays > 0) {
                            userAttr.setPasswordExpiration(this.expDays);
                            userAttr.setPasswordRulesEnforced(true);
                        } else {
                            userAttr.setPasswordRulesEnforced(false);
                            userAttr.setPasswordExpiration(0);
                        }
                        Trace.trace(TRACE_MASKT, "UserProfTasklet:calling modifyUser impl");
                        this.implClass.modifyUser(userAttr);
                        Trace.trace(TRACE_MASKT, "UserProfTasklet:back from calling modifyUser impl");
                        dataRepApp.displayCustDataWarning(sourceDataKey, this);
                        Trace.trace(TRACE_MASKT, "<- inside modifyUser");
                        this.usersBuilt = false;
                        PanelTaskletRequest requesta = new PanelTaskletRequest();
                        requesta.setData("action", "refresh_users");
                        this.postRequest(ADDUSERBEAN_NAME, requesta);
                        response.dispose(NEWUSERBEAN_NAME);
                        break block58;
                    }
                    if (myAction.equalsIgnoreCase("modifyUserPassword")) {
                        Trace.trace(TRACE_MASKT, "--> inside modifyUserPassword");
                        String newName = (String)request.getData("name");
                        String description = (String)request.getData("description");
                        LocalizableText desc = new LocalizableText(description);
                        String password = new String((String)request.getData("password"));
                        byte[] pass = password.getBytes();
                        String expireDays = (String)request.getData("expireDays");
                        this.expDays = Integer.valueOf(expireDays);
                        Trace.trace(TRACE_MASKT, "before implclass validatePassword");
                        if (this.expDays > 0) {
                            this.implClass.validatePassword(password, true);
                        } else {
                            this.implClass.validatePassword(password, false);
                        }
                        Trace.trace(TRACE_MASKT, "after implclass validatePassword");
                        UserAttributes userAttr = new UserAttributes(newName, pass, desc);
                        Trace.trace(TRACE_MASKT, "UserProfTasklet:calling modifyUser impl");
                        this.implClass.modifyUser(userAttr);
                        Trace.trace(TRACE_MASKT, "UserProfTasklet:back from calling modifyUser impl");
                        dataRepApp.displayCustDataWarning(sourceDataKey, this);
                        Trace.trace(TRACE_MASKT, "<- inside modifyUserPassword");
                        this.usersBuilt = false;
                        PanelTaskletRequest requesta = new PanelTaskletRequest();
                        requesta.setData("action", "refresh_users");
                        this.postRequest(ADDUSERBEAN_NAME, requesta);
                        response.dispose(NEWUSERBEAN_NAME);
                        break block58;
                    }
                    if (myAction.equalsIgnoreCase("refresh_users")) {
                        if (!this.usersBuilt) {
                            this.curUsers = this.buildTopUsers();
                        }
                        Trace.trace(TRACE_MASKT, "<> UserProfTasklet.refresh_users() " + this.curUsers.size());
                        response.update(ADDUSERBEAN_NAME, this.curUsers);
                        break block58;
                    }
                    response.noAction();
                }
                catch (UserProfilesException e) {
                    this.destroyBusyDialog();
                    if (e.getMsgType().equals(MsgType.ERROR_MESSAGE)) {
                        BaseMessageTitle title = new BaseMessageTitle("ADM9017");
                        MessageText[] bmt = new BaseMessageText[1];
                        Object[] values = new String[]{e.getLocalizedMessage()};
                        bmt[0] = new BaseMessageText("ADM0023", values);
                        LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                        try {
                            LocalizableText answer = this.showMessageBox(false, title, bmt, "ADM0023", MsgType.ERROR_MESSAGE, options);
                        }
                        catch (Exception exc) {
                            HException ex = new HException(exc);
                            new FrameworkLog(classLogInfo, 1025, ex).log();
                        }
                        response.noAction();
                        break block58;
                    }
                    BaseMessageTitle title = new BaseMessageTitle("ADM9024");
                    MessageText[] bmt = new BaseMessageText[1];
                    Object[] values = new String[]{e.getLocalizedMessage()};
                    bmt[0] = new BaseMessageText("ADM0027", values);
                    LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                    try {
                        LocalizableText answer = this.showMessageBox(false, title, bmt, "ADM0027", MsgType.INFORMATION_MESSAGE, options);
                    }
                    catch (Exception exc) {
                        HException ex = new HException(exc);
                        new FrameworkLog(classLogInfo, 1025, ex).log();
                    }
                    this.usersBuilt = false;
                    PanelTaskletRequest requesta = new PanelTaskletRequest();
                    requesta.setData("action", "refresh_users");
                    this.postRequest(ADDUSERBEAN_NAME, requesta);
                    response.dispose(NEWUSERBEAN_NAME);
                }
            }
        }
    }

    public void deleteObject(int mySel) {
        Trace.trace(TRACE_MASKT, "-> UserProfTasklet.deleteObject(mySel) " + mySel);
        if (mySel < this.curUsers.size()) {
            UserAttributes currentObject = (UserAttributes)this.curUsers.get(mySel);
            Trace.trace(TRACE_MASKT, "currentObject to delete is " + currentObject.getUserid());
            this.implClass.removeUser(currentObject.getUserid());
            Trace.trace(TRACE_MASKT, "UserProfTasklet:return from removeUser");
            dataRepApp.displayCustDataWarning(sourceDataKey, this);
            this.curUsers.remove(mySel);
        }
        Trace.trace(TRACE_MASKT, "<- UserProfTasklet.deleteObject(mySel)");
    }

    public List buildTopUsers() {
        Trace.trace(TRACE_MASKT, "-> UserProfTasklet.buildTopUsers() ");
        this.curUsers = new ArrayList();
        Trace.trace(TRACE_MASKT, "before implClass getUsers call ");
        UserAttributes[] attUsers = this.implClass.getUsers();
        Trace.trace(TRACE_MASKT, "after implClass getUsers call ");
        int i = 0;
        while (i < attUsers.length) {
            this.curUsers.add(attUsers[i]);
            ++i;
        }
        Trace.trace(TRACE_MASKT, "<- UserProfTasklet.buildTopUsers() ");
        return this.curUsers;
    }

    public void buildRoles() {
        Trace.trace(TRACE_MASKT, "-> UserProfTasklet.buildRoles() ");
        this.moRoles = this.implClass.getRoles(0);
        Trace.trace(TRACE_MASKT, "back from implClass.getRoles(0)");
        this.taskRoles = this.implClass.getRoles(1);
        Trace.trace(TRACE_MASKT, "<- UserProfTasklet.buildRoles() ");
    }

    public List buildObjectidList(List treeData) {
        ArrayList<Object> ids = new ArrayList<Object>();
        Trace.trace(TRACE_MASKT, "-> UserProfTasklet.buildObjectidList() ");
        int x = 0;
        while (x < treeData.size()) {
            RoleTree aTree = (RoleTree)treeData.get(x);
            ids.add(aTree.getKey());
            ++x;
        }
        Trace.trace(TRACE_MASKT, "<- UserProfTasklet.buildObjectidList() ");
        return ids;
    }

    public static UserProfilesPlugin loadPlugin() {
        UserProfilesPlugin plugin = null;
        Trace.trace(TRACE_MASKT, "-> UserProfTasklet.loadPlugin() ");
        try {
            String xmlFileName = BaseFileControl.getFilePath(CUSTOMIZE_XML) + CUSTOMIZE_XML;
            FileInputStream fis = new FileInputStream(xmlFileName);
            Document doc = new HwmcaParser(fis, false).getDocument();
            NodeList pluginNodes = doc.getElementsByTagName("userplugin");
            if (pluginNodes.getLength() > 0) {
                Element pluginElement = (Element)pluginNodes.item(0);
                NodeList pluginClasses = pluginElement.getElementsByTagName("class");
                if (pluginClasses.getLength() > 0) {
                    Node pluginNode = pluginClasses.item(0);
                    String pluginClassName = HwmcaParser.getValue(pluginNode);
                    Trace.trace(TRACE_MASKT, "plugin class name is " + pluginClassName);
                    Class<?> pluginClass = Class.forName(pluginClassName);
                    plugin = (UserProfilesPlugin)pluginClass.newInstance();
                    Trace.trace(TRACE_MASKT, "-> plugin is " + plugin);
                } else {
                    Trace.trace(TRACE_MASKT, "Error: no <class> tags found");
                }
            } else {
                Trace.trace(TRACE_MASKT, "Error: no <userplugin> tags found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Trace.trace(TRACE_MASKT, "<- UserProfTasklet.loadPlugin() ");
        return plugin;
    }
}

